import mongoose from "mongoose";
import dotenv from "dotenv";
import { v4 as uuidv4 } from 'uuid';

dotenv.config();

// Master Data Schema
const masterDataSchema = new mongoose.Schema({
  id: { type: String, required: true, unique: true },
  district: { type: String },
  location: { type: String },
  type: { type: String, enum: ["location", "car"] },
  model: { type: String },
  variant: { type: String },
  photoUrl: { type: String },
  brand: { type: String }
});

const MasterData = mongoose.model("MasterData", masterDataSchema);

const dummyData = [
  // Kochi
  { id: uuidv4(), district: 'Kochi', location: 'kalamassery : skoda service', type: 'location' },
  { id: uuidv4(), district: 'Kochi', location: 'kalamassery : volkswagen', type: 'location' },
  { id: uuidv4(), district: 'Kochi', location: 'cheranallur : volkswagen', type: 'location' },

  // Kottayam
  { id: uuidv4(), district: 'Kottayam', location: 'ettumanoor : skoda service', type: 'location' },
  { id: uuidv4(), district: 'Kottayam', location: 'kottayam : railway station', type: 'location' },
  { id: uuidv4(), district: 'Kottayam', location: 'thellakom : volkswagen', type: 'location' },

  // Trivandrum
  { id: uuidv4(), district: 'Trivandrum', location: 'Nh 66 bybass : kochuveli railway station', type: 'location' },
  { id: uuidv4(), district: 'Trivandrum', location: 'tampanur : central railway station', type: 'location' },
  { id: uuidv4(), district: 'Trivandrum', location: 'kazhakootam : railway station', type: 'location' },

  // Thrissur
  { id: uuidv4(), district: 'Thrissur', location: 'thrissur : railway station', type: 'location' },
  { id: uuidv4(), district: 'Thrissur', location: 'valarkavu : near ganam theater', type: 'location' },
  { id: uuidv4(), district: 'Thrissur', location: 'paliyekara : evm mg', type: 'location' },

  // Calicut
  { id: uuidv4(), district: 'Calicut', location: 'calicut : railway', type: 'location' },
  { id: uuidv4(), district: 'Calicut', location: 'calicut : airport', type: 'location' },
  { id: uuidv4(), district: 'Calicut', location: 'pavangad : evm nissan', type: 'location' },

  // Cars
  { id: uuidv4(), model: 'Alto 800', variant: 'manual', type: 'car', brand: 'maruthi' },
  { id: uuidv4(), model: 'Alto 800', variant: 'automatic', type: 'car', brand: 'maruthi' },
  { id: uuidv4(), model: 'SKODA SLAVIA PETROL AT', variant: 'automatic', type: 'car', brand: 'skoda' },
  { id: uuidv4(), model: 'NISSAN MAGNITE PETROL MT', variant: 'manual', type: 'car', brand: 'nissan' },
  { id: uuidv4(), model: 'SKODA KUSHAQ Petrol MT', variant: 'manual', type: 'car', brand: 'skoda' },
  { id: uuidv4(), model: 'SKODA KUSHAQ Petrol AT', variant: 'automatic', type: 'car', brand: 'skoda' },
  { id: uuidv4(), model: 'MG HECTOR Petrol MT', variant: 'manual', type: 'car', brand: 'mg' },
  { id: uuidv4(), model: 'MG HECTOR Petrol AT', variant: 'automatic', type: 'car', brand: 'mg' },
  { id: uuidv4(), model: 'MG HECTOR Diesel MT', variant: 'manual', type: 'car', brand: 'mg' },
  { id: uuidv4(), model: 'NISSAN TERRANO Diesel MT', variant: 'manual', type: 'car', brand: 'nissan' },
  { id: uuidv4(), model: 'NISSAN KICKS Petrol MT', variant: 'manual', type: 'car', brand: 'nissan' },
  { id: uuidv4(), model: 'VW TAIGUN Petrol MT', variant: 'manual', type: 'car', brand: 'volkswagen' },
  { id: uuidv4(), model: 'HYUNDAI ALCAZAR Diesel AT', variant: 'automatic', type: 'car', brand: 'hyundai' },
  { id: uuidv4(), model: 'MARUTI SWIFT Petrol AT', variant: 'automatic', type: 'car', brand: 'maruthi' },
  { id: uuidv4(), model: 'MARUTI DZIRE Petrol MT', variant: 'manual', type: 'car', brand: 'maruthi' },
  { id: uuidv4(), model: 'VW VENTO Petrol MT', variant: 'manual', type: 'car', brand: 'volkswagen' },
  { id: uuidv4(), model: 'VW POLO Petrol MT', variant: 'manual', type: 'car', brand: 'volkswagen' },
];

async function seedDatabase() {
  try {
    await mongoose.connect(process.env.mongo_uri);
    console.log('Connected to MongoDB');

    // Clear existing data
    await MasterData.deleteMany({});
    console.log('Cleared existing master data');

    // Insert new data
    await MasterData.insertMany(dummyData);
    console.log('✅ Master data seeded successfully!');
    console.log(`   - ${dummyData.filter(d => d.type === 'location').length} locations added`);
    console.log(`   - ${dummyData.filter(d => d.type === 'car').length} car models added`);

  } catch (error) {
    console.error('Error seeding database:', error);
  } finally {
    await mongoose.disconnect();
    console.log('Disconnected from MongoDB');
  }
}

seedDatabase();
